## Debug

BEGIN {
	$| = 1;

	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";

	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

package Test;

use Debug;
my $d = new Debug( { 'DefaultCount' => 1 } );

$d->stack( 17 );

# $d->set( 'func_a', 3 );
# $d->set( 'func_b', 2 );
$d->set( 'func_c', 5 );

# $d->trace( "func_c" );
# $d->_resetcount( "func_c" );

# printf "\n func_a.count=( %d )", $d->count( "func_a" );
# printf "\n func_b.count=( %d )", $d->count( "func_b" );
printf "\n func_c.count=( %d )", $d->count( "func_c" );
print "\n";

#-------------------------------
 map {
	Debug::clear();
	func_c( $_ );
#	func_a( $_ ) if ( $_ % 2 );
#	func_b( $_ ) if ( $_ % 3 );
#	func_c( $_ ) if ( $_ % 4 );

	print "\n".Dumper( $d );
	my $in=<STDIN>;
} 1..10;

#-------------------------------
# sub func_a {
# 	my $v = shift;
# 	$d->trace( "func_a" );

# 	printf "\n func_a.count=( %d )", $d->count( "func_a" );
# 	return func();
# }


# sub func_b {
# 	my $v = shift;
# 	$d->trace( "func_b" );

# 	printf "\n func_b.count=( %d )", $d->count( "func_b" );
# 	return func();
# }


sub func_c {
	my $name = 'func_c';
	print "\n{ $name }" if ( $d->ifzero( $name ) );
	my $v = shift;
	$d->trace( "func_c" );

	printf "\n func_c.count=( %d )", $d->count( "func_c" );
	return func();
}


sub func {
	my $name = 'func_c';
	my $zr = $d->ifzero( $name );
	my $nz = $d->ifnozero( $name );
	my $lz = $d->ifltzero( $name );
	my $gz = $d->ifgtzero( $name );

	printf "\nzero=( %d ) ", $zr;
	printf "nozero=( %d ) ", $nz;
	printf "ltzero=( %d ) ", $lz;
	printf "gtzero=( %d ) ", $gz;

	$d->unset( "func_c" ) if ( $d->count( "func_c" ) <= -1 );
}


1;
