## Timer

BEGIN {
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

package Test;

use utf8;
use strict;
use warnings;
use Encode qw( encode decode );
use Data::Dumper;
use Debug;

use BBS::Timer;

# map { printf "\n** (%d):(%d) - (%d)", $_, ($_ % 2), ( ($_ >= 1) && ($_ % 2) ) ? 1 : 0 } (-1..4);

my $interval;
$interval = ( 1000000 * 3 );				# 3秒
# $interval = ( 0 );
# my $interval = ( 1000000 * 60 * 60 * 24 );


## new()
## obj = new( interval )
# intervalを定義すると、タイムアウト値を設定
my $t2 = new BBS::Timer( $interval );
print "\n[t2]\n".Dumper($t2);


## now()
## now = now()
my $now = $t2->now();
print "\n[now]\n".Dumper($now);




# ## timeout()
# ## r = timeout()
# printf "\n** timeout=(%d)", $t2->timeout();

while ( $t2->timeout() == 0 ) {

	## timeleft()
	## r = timeleft()
	my ( $l_sec, $l_msec ) = @{ $t2->timeleft() };
	# printf "\nleft = (%d.%06d)", $l_sec, $l_msec;				# タイムアウトまでの残り時間
	my $l = sprintf "%d.%06d", $l_sec, $l_msec;					# 数値に変換
	# printf "\n  left = (%.06f)", $l;								# ???? 経過時間


	## elapse()
	## r = elapse()
	my ( $e_sec, $e_msec ) = @{ $t2->elapse() };
	# printf "\nelapse = (%d.%06d)", $e_sec, $e_msec;			# タイムアウトまでの残り時間
	my $e = sprintf "%d.%06d", $e_sec, $e_msec;					# 数値に変換
	# printf "\nelapse = (%.06f)", $e;							# ???? 経過時間
	# $e = $e + 1.50;												# 数値に加算
	# printf "\nelapse = (%.06f)", $e;								# ???? 経過時間
	# last if ( $e > 1.25 );

	# print "\n";
}

print "\n";
my $l = $t2->timeleft();
printf "\nleft = (%d.%06d)", $l->[0], $l->[1];				# タイムアウトまでの残り時間
my $e = $t2->elapse();
printf "\nelapse = (%d.%06d)", $e->[0], $e->[1];			# 経過時間

# print "\n***********";

exit;

# #------------------------------
# $t2->reset( $interval );
# #------------------------------

# while ( $t2->timeout() == 0 ) {

	# ## timeleft()
	# ## r = timeleft()
	# my ( $l_sec, $l_msec ) = @{ $t2->timeleft() };
	# # printf "\nleft = (%d.%06d)", $l_sec, $l_msec;				# タイムアウトまでの残り時間
	# my $l = sprintf "%d.%06d", $l_sec, $l_msec;					# 数値に変換
	# # printf "\n  left = (%.06f)", $l;								# ???? 経過時間


	# ## elapse()
	# ## r = elapse()
	# my ( $e_sec, $e_msec ) = @{ $t2->elapse() };
	# # printf "\nelapse = (%d.%06d)", $e_sec, $e_msec;			# タイムアウトまでの残り時間
	# # my $e = sprintf "%d.%06d", $e_sec, $e_msec;					# 数値に変換
	# # printf "\nelapse = (%.06f)", $e;							# ???? 経過時間
	# # $e = $e + 1.50;												# 数値に加算
	# # printf "\nelapse = (%.06f)", $e;								# ???? 経過時間
	# # last if ( $e > 1.25 );

	# # print "\n";
# }

# print "\n";
# $l = $t2->timeleft();
# # printf "\nleft = (%d.%06d)", $l->[0], $l->[1];			# タイムアウトまでの残り時間
# $e = $t2->elapse();
# # printf "\nelapse = (%d.%06d)", $e->[0], $e->[1];			# 経過時間

# printf "\n** timeout=(%d)", $t2->timeout();					# タイムアウトチェック



#=====================================
# ２秒ごとにリセットし、セットからタイムアウトまでの経過時間を計測
#=====================================
my $cnt = 10;
$interval = 1000000;		# 1秒

$t2->reset( $interval );



while ( $cnt > 0 ) {
	if ( $t2->timeout() == 1 ) {
		$cnt--;
		printf "\n** ( %d ) **", $cnt;
		my ( $e_sec, $e_msec ) = @{ $t2->elapse() };
		printf "\nelapse = (%d.%06d)", $e_sec, $e_msec;
		$t2->reset( $interval );
		print Dumper( $t2 );		# ????
	}
	my $left = $t2->timeleft();
	print "\n".Dumper($left)."\n";
}

1;