## Node

BEGIN {
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

package Test;

use utf8;
use strict;
use warnings;
use Encode qw( encode decode );
use Data::Dumper;
use Debug;

use BBS::Node;

Debug::clear();

## new()
my $n = new BBS::Node();
# print "\n[Node]\n".Dumper($n);


## add( num )
$n->add( 6 );
# print "\n[add]\n".Dumper( $n );
$n->add( 4 );
# print "\n[add]\n".Dumper( $n );
$n->add( 5 );
print "\n[add]\n".Dumper( $n );


## node( num )
$n->node( 8 )->{'name'} = 123;
printf "\nnode.err = ( %d )", $n->err();

$n->node( 'A' )->{'name'} = 123;
printf "\nnode.err = ( %d )", $n->err();

$n->node( 4 )->{'name'} = 123;
printf "\nnode.err = ( %d )", $n->err();

print "\n[node]\n".Dumper( $n );

## nodelist()
print "\n[nodelist]\n".Dumper( $n->nodelist() );


## remove( num )
my $r = $n->remove( 5 );
printf "\nremove.r = ( %d )", $r;
print "\n[remove]\n".Dumper( $n );


1;