## Handler

BEGIN {
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

package Test;

use utf8;
use strict;
use warnings;
use Encode qw( encode decode );
use Data::Dumper;
use Debug;

use BBS::Handler;

# Debug::clear();

## new()
my $h = new BBS::Handler();
print "\n[h]\n".Dumper( $h );			# ????

## set(), order()
$h->set( 'A', sub { $h->Test::a(@_) } );
$h->set( 'B', sub { $h->Test::b(@_) } );
$h->set( 'C', sub { $h->Test::c(@_) } );
print "\n[h]\n".Dumper( $h );			# ????
print "\n[h]\n".Dumper( $h->order() );			# ????

$h->set( 'D', sub { $h->Test::d(@_) }, 'A' );
$h->set( 'E', sub { $h->Test::e(@_) }, 'A' );
print "\n[h]\n".Dumper( $h );			# ????
print "\n[h]\n".Dumper( $h->order() );			# ????


## order()
my $order = $h->order();
print "\n[order]\n".Dumper( $order );			# ????

@{ $order } = reverse( @{ $order } );
print "\n[order.reverse]\n".Dumper( $order );			# ????

$order = $h->order();
print "\n[reorder]\n".Dumper( $h );			# ????

## del()
$h->del( 'B' );
print "\n[h]\n".Dumper( $h );			# ????
print "\n[h]\n".Dumper( $h->order() );			# ????


## call()
$h->call();
$h->call( 'A','B','C' );


##==================================================
## ハンドラルーチン
##==================================================
sub a {
	print "\n\t=== [ a ]";
	# print "\n[\@_]\n".Dumper(@_);
	print "\n\t=== [ /a ]";
}
sub b {
	print "\n\t=== [ b ]";
	# print "\n[\@_]\n".Dumper(@_);
	print "\n\t=== [ /b ]";
}
sub c {
	print "\n\t=== [ c ]";
	# print "\n[\@_]\n".Dumper(@_);
	print "\n\t=== [ /c ]";
}
sub d {
	print "\n\t=== [ d ]";
	# print "\n[\@_]\n".Dumper(@_);
	print "\n\t=== [ /d ]";
}
sub e {
	print "\n\t=== [ e ]";
	# print "\n[\@_]\n".Dumper(@_);
	print "\n\t=== [ /e ]";
}
1;