## IO::Input

BEGIN {
	$| = 1;
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		'C:/Projects/bbs_pm/lib',
		'C:/Projects/bbs_pm/apps/bbs/test/module/.lib',
		$basedir.'/.lib',
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

package Test;

use utf8;
use strict;
use warnings;
use Encode qw( encode decode );
use Data::Dumper;
use Debug;

# Debug::clear();

use BBS::IO;
use BBS::IO::Input;

my $data = [

		'0123456789ABC',
		# '0１2３4５6７8９ABC',

		# "\xe3\x81\x82ABC",
		# 'あABC',


		# "あいうえお",
		# "ｳﾞｪｰﾄｰﾍﾞﾝ",
	# 	"_ｱ1ｲ23ｳ_",
	# 	"\x0d\x0a\x0a",

	# 	# "あ",

	# 	# "12",
	# 	# "345",
	# 	"67890ABC",

		# "\x0d\x0a\x0a",

 		# "\xef".
		# "\xbc".
		# "\x91".
		# '',

 		# "\xef".
		# "\xbc".
		# "\x0d".
		# "\x91".
		# '',

		# "ＡＢＣＤ\r",
		# "１２３４\r\n\n",
		# "あいうえ\r\n",

		# 'あ.いうえ'."\x20\x09う\x0d",

		# "\xe3\x81\x82",
		# "\xe3\xe3\x81\x82",					# broken_data

		# '３.４５６'."\x20\x09６\x0d\x0a",
		# "７ ",

		# "ｳﾞｪｰﾄｰﾍﾞﾝ",
		# "\xef\xbd\xb3", 	# "ｳﾞｪｰﾄｰﾍﾞﾝ",
		# "\xef\xbe\x9e", 
		# "\xef\xbd\xaa", 
		# "\xef\xbd\xb0", 
		# "\xef\xbe\x84", 
		# "\xef\xbd\xb0", 
		# "\xef\xbe\x8d", 
		# "\xef\xbe\x9e", 
		# "\xef\xbe\x9d", 

#		"\x0d",

# 		'', 

# 		undef, 

		# 受信データ（通信データはバイナリなので、ASCII以外は\xnnで指定）
		# Inputで取り込むときはエンコードしてバイナリにする
		# Outputで取り込むときはデコードして文字単位にする 

		# "あ",
		# decode( 'utf8', "\xe3\x81" ),					# 'あ'
		# decode( 'utf8', "\x82" ),					# 'あ'

	# # broken_data
		# "\xe3\xe3\x81",
		# "\xe3\xe3\x00\x82",
		# "\xe4\xe3\x81\x82",

];


#--------------------------------
## new()
#--------------------------------
my $io = new BBS::IO();
my $in = new BBS::IO::Input();


# Test::store();
#--------------------------------
## store( data )
#--------------------------------
sub store {
	# printf "\n\n=== { %s }", __PACKAGE__.'::store';			# ????
	# printf "\n=== ( %s )", Debug::_caller(caller);		# ????
	map {
		if ( ( defined( $_ ) == 1 ) && ( $_ ne '' ) ) {							# 定義済みかつヌルでない

			my $d = ( utf8::is_utf8( $_ ) ) ? encode( 'utf8', $_ ) : $_;			# utf8ならバイナリにエンコード
			# print "\n{ d }\n";													# ????
			# $io->_dmp( $d );													#
			# print "\n";															# ????

			my @bytes_ary = split( //, $d );											# バイトごとに分割して
			map {
			 	$in->store( $_ );														# バッファに取り込む
				# printf "\nerr = ( %d )", $in->err();									# ???? エラーコード
			} @bytes_ary;

			# printf "\n\nbuf.count = ( %d )", $in->count();						# ???? モジュール内部バッファのレコード数
		}
	} @{ $data };
	printf "\n\ncount = ( %d )", $in->count();		# ???? データのレコード数
}


# Test::get();
#--------------------------------
## get( bytes )
#  1バイト単位で参照
#--------------------------------
sub get {
	printf "\n\n=== { %s }", __PACKAGE__.'::get';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);		# ????

	Test::store();

	map {
		my @arg = @{ $_ };							# 取得サイズ
		printf "\n=========={ _arg }\n".Dumper( @arg );				# ????

		my $data = $in->get( @arg );						# 取得したデータ
		printf "\n\n*** get.err = ( %d )", $in->err();		# ???? エラーコード

		if ( defined( $data ) ) {						# ????
			my $d = join( '', @{ $data } );					# 取得したデータを結合
			print "\n{ data }\n";
			$io->_dmp( $d, 5 )
		}

		printf "\n\ncount = ( %d )", $in->count();		# ???? データのレコード数
	} ( [ ], [ -1 ], [ 1 ], [ 3 ], [ 2, 2 ], [ 100 ] );

}


# Test::fetch();
#--------------------------------
## fetch( bytes )
#  1バイト単位で取り出す
#--------------------------------
sub fetch {
	printf "\n\n=== { %s }", __PACKAGE__.'::fetch';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);		# ????

	Test::store();

	map {
		my $size = $_;									# 取得サイズ
		printf "\n{ _arg }\n".Dumper( $_ );				# ????

		my $data = $in->fetch( $size );						# 取得したデータ
		printf "\n\n*** fetch.err = ( %d )", $in->err();	# ???? エラーコード

		if ( defined( $data ) ) {						# ????
			my $d = join( '', @{ $data } );					# 取得したデータを結合
			print "\n[data]\n";
			$io->_dmp( $d, 5 )
		}

		printf "\n\ncount = ( %d )", $in->count();		# ???? データのレコード数
	} ( undef, 1, 3, 4, 5, 9, 100 );

}

# Test::getchr();
#--------------------------------
## getchr()
#  一文字参照
#--------------------------------
sub getchr {
	printf "\n\n=== { %s }", __PACKAGE__.'::getchr';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);		# ????

	Test::store();

	for ( my $c = 10; $c > 0; $c-- ) {
		if ( my $r = $in->getchr() ) {							# 一文字取得
			my ( $len, $chr ) = @{ $r };
			$chr = join( ',', $chr );
			printf "\n\n-- getchr.len = ( %d )", $len;
			printf "\n-- getchr.chr = [ %s ]", decode( 'utf8', $chr );
			printf "\n-- cp932len = ( %d )", $io->cp932len( $chr );

			my $fetch =	$in->fetch( $len );
			print "\n{ fetch }\n";
			# print Dumper( $fetch );
			$io->_dmp( join( '', @{ $fetch } ) );
			print "\n";
		}
		else {
			last;
		}
	}
	printf "\n\ncount = ( %d )", $in->count();		# ???? データのレコード数
}


# Test::fetchchr();
#--------------------------------
## fetchchr()
#  一文字取出し
#--------------------------------
sub fetchchr {
	printf "\n\n=== { %s }", __PACKAGE__.'::fetchchr';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);		# ????

	Test::store();

	for ( my $c = 10; $c > 0; $c-- ) {
		my $chr = $in->fetchchr();

		if ( defined( $chr ) ) {							# 一文字取得
			# print "\n{ fetchchr }\n";					# ????
			# $io->_dmp( encode( 'utf8', $chr ) );		# ????
			# print "\n";									# ????

			printf "\nchr = [%s]", $chr;									# ????
			printf "\nchr.cp932len = ( %d )", $io->cp932len( $chr );		# ????

			printf "\n\ncount = ( %d )", $in->count();		# ???? データのレコード数
		}
	}

	printf "\n\ncount = ( %d )", $in->count();		# ???? データのレコード数
}

# Test::codetype();
#--------------------------------
## codetype()
#--------------------------------
sub codetype {
	printf "\n\n=== { %s }", __PACKAGE__.'::codetype';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);		# ????
	my $str;
	my $c = 1;

	map {
		printf "\n%d :", ( $_ + 1 );			# ???? カウンタ
		my $dt = $data->[ $_ ];

		my $is_enc = $io->is_encode( $dt );
		my $is_dec = $io->is_decode( $dt );
		my $r;

		if ( $is_enc < $is_dec ) {
			$r = 'decode';
		}			
		elsif ( $is_enc > $is_dec ) {
			$r = 'encode';
		}			
		elsif ( $is_enc == $is_dec ) {
			$r = 'unknown';
		}			

		printf "\n** is_encode = ( %d )", $is_enc;
		printf ", is_decode = ( %d )", $is_dec;
		printf ", codetype = [ %s ]", $r;

		my $dt_dmp = ( $is_dec ) ? encode( 'utf8', $dt ) : $dt;
		# $io->_dmp( $dt_dmp, 0 );

		my $is_utf8 = $io->is_utf8( $dt );
		printf "\n** is_utf8 = ( %d )", $is_utf8;

		if ( $is_utf8 ) {
			printf "\n** str = [%s]", ( $is_enc ) ? decode( 'utf8', $dt ) : $dt;
			printf "\n** cp932len = ( %d )", $io->cp932len( $dt );
		}
		else {
			printf "\n** cp932len = ( %d ) - failed", $io->cp932len( $dt );
		}

		print "\n";			# ????
	} ( 0..$#{ $data } );
}


# Test::cp932len();
#--------------------------------
## cp932len()
#--------------------------------
sub cp932len {
	printf "\n\n=== { %s }", __PACKAGE__.'::cp932len';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);		# ????
	my $str;
	my $c = 1;

	map {
		printf "\n%d :", ( $_ + 1 );			# ???? カウンタ
		my $dt = $data->[ $_ ];

		my $is_enc = $io->is_encode( $dt );
		my $is_utf8 = $io->is_utf8( $dt );
		printf "\n** is_utf8 = ( %d )", $is_utf8;

		if ( $is_utf8 ) {
			printf "\n** str = [%s]", ( $is_enc ) ? decode( 'utf8', $dt ) : $dt;
			printf "\n** cp932len = ( %d )", $io->cp932len( $dt );
		}
		else {
			printf "\n** cp932len = ( %d ) - failed", $io->cp932len( $dt );
		}
		print "\n";			# ????
	} ( 0..$#{ $data } );
}


Test::insert();
#--------------------------------
## insert()
#--------------------------------
sub insert {
	printf "\n\n=== { %s }", __PACKAGE__.'::insert';			# ????
	printf "\n=== ( %s )", Debug::_caller(caller);				# ????
	my @data = ( 'A', 'B', 'C', encode( 'utf8', 'あ' ) );

	Test::store();

	map {
		my $chr = shift( @data );
		$in->insert( $chr );

		my $data = $in->get( -1 );
		printf "\ndata.str = [ %s ]", decode( 'utf8', join( '', @{ $data } ) );
		print "\n{ data }\n";
		$io->_dmp( join( '', @{ $data } ) );
		print "\n";

	} ( 1,3,5,6 );
}

1;