## IO::Buffer

BEGIN {
	$| = 1;
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		'C:/Projects/bbs_pm/lib',
		'C:/Projects/bbs_pm/apps/bbs/test/module/.lib',
		$basedir.'/.lib',
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};


package Test;

use utf8;
use strict;
use warnings;
use Encode qw( encode decode );
use Data::Dumper;
use Debug;

use BBS::IO::Buffer;
use BBS::IO::Input;


my @data = split( //, "0123456789" );
# my @data = split( //, "abcdefghij" );
# my @data = split( //, encode( 'utf8', "あ1い23う4え5お" ) );
# my @data = split( //, "あ1い23う4え5お" );
my @ary;

## new()
my $b = new BBS::IO::Buffer();
my $in = new BBS::IO::Input();

print "\n{ data }\n"; $in->_dmp( join( '', @data ) );			# ????


## in
# Test::fi();		# unshift(first-in)
# Test::li();		# push(last-in)
print "\n";

## out
# Test::fo();		# shift(first-out)
# Test::lo();		# pop(last-out)
print "\n";

## get
Test::get();
print "\n";

## clear
# Test::clear();

print "\n";




#==================================================
# input
#==================================================
## fi()
sub fi {
	map {
		$b->firstin( $_ );
		unshift( @ary, $_ );
		printf "(%2d) [%30-s] [%30s] (%2d)\n",
				$b->count(), 
				join( '', @{ $b->get() } ), 
				join( '', @ary ), 
				$#ary+1;
	} @data;
}

## li()
sub li {
	map {
		$b->lastin( $_ );
		push( @ary, $_ );
		printf "(%2d) [%20s] [%20s] (%2d)\n",
				$b->count(), 
				join( '', @{ $b->get() } ), 
				join( '', @ary ), 
				$#ary+1
	} @data;
}

#==================================================
# output
#==================================================
## fo()
sub fo {
	my $type = shift || 0;

	# { type-2 }
	if ( $type == 2 ) {
		map {
			my $qty = $_;
#			printf "\nqty = ( %d )", $qty;

			my $v1 = $b->firstout( $qty );
			my @v2 = splice( @ary, 0, $qty );

			printf "(%5s) [%30s] (%d) [%30s] (%5s) \n",
					join( '', @{ $v1 } ), 
					join( '', @{ $b->get() } ), 
					$_, 
					join( '', @ary ), 
					join( '', @v2 ), 

		} ( 0..$#data );
	}

	# { type-1 }
	else {
		while ( my $cnt = $b->count() ) {
			printf "(%2d) : ", $cnt;
			my $v1 = $b->firstout();
			my $v2 = shift( @ary );
			printf "(%s) [%10s] [%10s] (%s) \n",
					join( '', @{ $v1 } ), 
					join( '', @{ $b->get() } ), 
					join( '', @ary ), 
					$v2;
		}
	}
}

## lo()
sub lo {
	my $type = shift || 0;

	# { type-2 }
	if ( $type == 2 ) {
		map {
			my $qty = $_;
#			printf "\nqty = ( %d )", $qty;

			my $v1 = $b->firstout( $qty );
			my @v2 = splice( @ary, 0, $qty );

			printf "(%5s) [%10s] (%d) [%10s] (%5s) \n",
					join( '', @{ $v1 } ), 
					join( '', @{ $b->get() } ), 
					$_, 
					join( '', @ary ), 
					join( '', @v2 ), 

		} ( 0..$#data );
	}

	# { type-1 }
	else {
		while ( my $cnt = $b->count() ) {
			printf "(%2d) : ", $cnt;
			my $v1 = $b->lastout();
			my $v2 = shift( @ary );
			printf "(%s) [%10s] [%10s] (%s) \n",
					join( '', @{ $v1 } ), 
					join( '', @{ $b->get() } ), 
					join( '', @ary ), 
					$v2;
		}
	}
}

#==================================================
## get()
sub get {
	$b->lastin( @data );
	my $buf;

	map {
		my @arg = @{ $_ };

		$buf = $b->get( @arg );
		printf "\nerr = ( %d )", $b->err();				# ????
		print "\n[ buf ]\n"; $in->_dmp( join( '', @{ $buf } ) );			# ????
		print "\n****\n";

	} ( [ ], [ -1 ], [ 3 ], [ 0, 4 ] );
	# } ( [ 0 ] );
}

#==================================================
## clear()
sub clear {
	printf "\n\n==( %s::clear [ %s ] )\n", __PACKAGE__, Debug::_caller(caller) if ( Debug::envchk( '<clear' ) );						# ????

	my $buf;
	print "\n** ( before )";						# ????
	$buf = $b->get();
	printf "\nerr = ( %d )", $b->err();				# ????
	print "\n[ buf ]\n".Dumper( @{ $buf } )."\n";	# ????

	$b->clear();
	print "\n** ( after )";							# ????
	$buf = $b->get();
	printf "\nerr = ( %d )", $b->err();				# ????
	print "\n[ buf ]\n".Dumper( @{ $buf } )."\n";	# ????
}

1;