package Debug;
our $NOLOAD = 1;
#===========================================================
# デバッグライブラリ
#
our $VERSION = [
	"----.--------.----"
];
#===========================================================
use utf8;
use strict;
use warnings;
use Encode qw( encode decode );
use Time::HiRes qw( tv_interval gettimeofday );
use Win32::Console::ANSI;
use Data::Dumper;
	$Data::Dumper::Sortkeys = 1;			# ハッシュのキーをソートする
#	$Data::Dumper::Indent = 1;				# インデントを縮める
#	$Data::Dumper::Terse = 1;				# $VAR数字要らない


#【 その他 】
my $ctrlcode = [										# 制御文字置換テーブル（テスト用）
	'NUL', 'SOH', 'STX', 'ETX', 'EOT', 'ENQ', 'ACK', 'BEL',
	'BS',  'HT',  'LF',  'VT',  'FF',  'CR',  'SO',  'SI',
	'DLE', 'DC1', 'DC2', 'DC3', 'DC4', 'NAK', 'SYN', 'ETB',
	'CAN', 'EM',  'SUB', 'ESC', 'FS',  'GS',  'RS',  'US'
];


#==================================================
# r = _caller();
#==================================================
sub _caller {
	# print "[\n".Dumper( @_ )."]\n";			# ????
	my $self = shift;

	my $str;
	if ( $#_ == 1 ) {
		$str = sprintf( "src=( %s:%s )", $_[0], $_[1] );
	}
	elsif ( $#_ == 2 ) {
		$str = sprintf( "pkg=( %s ), src=( %s:%s )", $_[0], $_[1], $_[2] );
	}
	else {
		$str = join(',', @_ );
	}

	return $str;
}


#==================================================
# 画面消去
# clear()
#==================================================
sub clear {
	print STDOUT "\n\x1b[2J";
}


#==================================================
# ダンプ
# dump( str )
#==================================================
sub dump {
	my $data = shift;
	my $len;															# データ長
	my $cnt;															# utf8文字数

	# utf8フラグチェック
	my $utf8flg = utf8::is_utf8( $data );								# utf8フラグ
	# printf "\nutf8flg = [ %s ]\n", ( $utf8flg ? "on" : "off" );		# ???? utf8フラグの状態

	if ( $utf8flg ) {													# utf8フラグがセットされている
		$cnt = length( $data );												# utf8文字数
		$len = length( encode( 'utf8', $data ) );							# データ長
	}
	else {																# utf8フラグがセットされていない
		$len = length( $data );												# データ長
	}
	printf "\nblock(s) = ( %d )", $len;									# ???? データ長
	printf ", cnt = ( %d )", $cnt if ( defined( $cnt ) );				# ???? 文字数
	print "\n";															# ????

	map {
		my ( $chr, $hex );
		# printf "\n[%02x]", ord($_);

		# ■UTF8
		if ( ord($_) > 255 ) {
			$chr = sprintf( "'%s'", $_ );
			$hex = join( '', map {
									sprintf "[%02x]", ord($_)
								} split( '', encode( 'utf8', $_ ) ) );
		}

		# ■ASCII
		else {
			if ( ord($_) <= 31 ) {
				my $mark = ( ord($_) == 0 )
							? ''
							: sprintf( " : ^%s", chr( ord($_) + ord( "\x40" ) ) );
				$chr = sprintf( "<%s>%s", $ctrlcode->[ ord($_) ], $mark );
			}
			elsif ( ord($_) >= 128 ) {
				$chr = "'??'";
			}
			else {
				$chr = sprintf( " '%s'", $_ );
			}
			$hex = sprintf( "[%02x]", ord($_) );
		}
		printf "\n--  %s  %s", $chr, $hex;
	} split( //, $data );

	print "\n";
}

#==================================================
# hexダンプ
# hexdump( utf8str_decode )
#==================================================
sub hexdump {
	my $data = shift;

	# (1) コードタイプ判定
	# printf "\n is_utf8 = ( %d )", utf8::is_utf8( $data );		# utf8フラグ( 0: エンコード, 1: デコード )
	my $is_decode = is_decode( $data );							# デコード判定( 0: エンコード, 1: デコード )
	# printf "\nis_decode = ( %d )", $is_decode;

	# エンコードされていたらデコードする
	if ( $is_decode == 0 ) {
		my $data_dec = decode( 'utf8', $data );
		my $r = is_decode( $data_dec );								# 再度デコード判定
		# printf "\nr = ( %d )", $r;								# ???? 
		$data = $data_dec if ( $r == 1 );
	}

	# (2) ダンプ出力
	map {
		my $chr = $_;
		if ( ord( $chr ) > 255 ) {										# multibyte
			printf "\n:\t [ %s ]", $chr;
			my $chr_enc = encode( 'utf8', $chr );
			map {
				printf "\n:\t\t [ %02x ] ( %d )", ord( $_ ), ord( $_ );
			} split( //, $chr_enc );
		}
		else {														# ASCII
			my $sym;
			my $chr_ord = ord( $chr );

			if ( $chr_ord <= 30 ) {
				$sym = sprintf( "%s", $ctrlcode->[ ord( $chr ) ] );
				printf "\n:\t < %s >", $sym;
			}
			elsif ( ( $chr_ord >= 31 ) && ( $chr_ord <= 127 ) ) {
				printf "\n:\t [ %s ]", $chr;
			}

			printf "\n:\t\t [ %02x ] ( %d )", ord( $chr ), ord( $chr );
		}
	} split( //, $data );
}

#==================================================
# デコード判定
# r = is_decode( str );
# r = { 0:encode , 1:decode }
#==================================================
sub is_decode {
	my $data = shift;
	my $r = 0;

	foreach my $chr ( split( //, $data ) ) {
	 	my $oct_chr = ord( $chr );
		# printf "\n( %s ) [ %02x ]", $oct_chr, $oct_chr;		# ????
		# デコードしたものは、文字コードが255を超える
		# エンコードしたものは、文字コードが255をこえない（バイナリ）
		if ( $oct_chr > 255 ) {
			$r = 1; last;
		}
	}

	return $r;
}

#==================================================
# r = envchk( ptn );
sub envchk {
	# my $r = 0;

	# $r++ if ( defined( $ENV{'BBS_PM_DEBUG'} ) );		# デバッグフラグが未定義(1)
	# my $ptn = shift;
	# $r++ if ( defined( $ptn ) );						# パターンが未定義(1)

	# if ( $r == 2 ) {													# デバッグフラグとパターンが両方定義済み
		# # print "\n[ BBS_PM_DEBUG ]\n". Dumper( $ENV{'BBS_PM_DEBUG'} );		# ????
		# # print "\n[ ptn ]\n". Dumper( $ptn );								# ????
		# $r = ( $ENV{'BBS_PM_DEBUG'} =~ /$ptn/ ) ? 1 : 0;				# パターン一致(1)
	# }
	# else {																# いずれかもしくは両方が未定義
		# $r = 1;																# 有効(1)
	# }

	# return $r;
}


#==================================================
# new()
#==================================================
sub new {
	my $class = shift;
	my $self = ( $#_ >= 0 ) ? shift : { };
	bless( $self, $class );
	$self->_init();
	return $self;
}

sub _init {
	my $self = shift;

	# スタック
	$self->{'Stack'}			= [ undef ],
								# $self->{'Stack'} = [ name, name, ... ];

	# スタック数
	$self->{'StackSize'}		= 0,

	# カウンタ
	$self->{'Count'}			= { },
								# $self->{'Count'}->{ name } = count;

	# デフォルトカウント値
	$self->{'DefaultCount'}		= exists( $self->{'DefaultCount'} ) ? $self->{'DefaultCount'} : 1,
}

sub err {
	my $self = shift;
	return $self->{'err'} if ( $#_ < 0 );			# 引数がなければエラーを返す
	$self->{'err'} = shift;							# 引数があればエラーをセット
}

#==================================================
# Stack-Trace
#==================================================
## stack( cnt );
sub stack {
	my $self = shift;
	my $size = shift;
	return if ( $size <= 0 );
	$size--;

	$self->{'StackSize'} = $size;		# スタック数の上限（個数）
	$self->{'Stack'} = [ ];				# スタック数の上限（個数）
	$self->{'Count'} = { };				# カウンタ
}

##==================================================
## trace( name );
sub trace {
	my $self = shift;
	my $name = shift;					# 登録する名前

	# スタックに追加
	push( @{ $self->{'Stack'} }, $name );

	# スタック数を超えている場合は詰める
	shift( @{ $self->{'Stack'} } ) if ( $self->{'StackSize'} < $#{ $self->{'Stack'} } );

	# カウンタがなければ規定値でリセット
	$self->_resetcount( $name );

	# カウントダウン
	$self->{'Count'}->{ $name }-- if ( $self->{'Count'}->{ $name } > -1 );
}

##==================================================
## print "aaaa" if ( $d->ifzero( name ) );
## ifzero( name )
sub ifzero {
	my $self = shift;
	my $name = shift;

	# カウンタがなければ規定値でリセット
	$self->_resetcount( $name );
	return ( $self->{'Count'}->{ $name } == 0 ) ? 1 : 0;
}

##==================================================
## ifnozero( name )
sub ifnozero {
	my $self = shift;
	my $name = shift;

	$self->_resetcount( $name );
	return ( $self->{'Count'}->{ $name } != 0 ) ? 1 : 0;
}

##==================================================
## ifltzero( name )
sub ifltzero {
	my $self = shift;
	my $name = shift;

	$self->_resetcount( $name );
	return ( $self->{'Count'}->{ $name } < 0 ) ? 1 : 0;
}

##==================================================
## ifgtzero( name )
sub ifgtzero {
	my $self = shift;
	my $name = shift;

	$self->_resetcount( $name );
	return ( $self->{'Count'}->{ $name } > 0 ) ? 1 : 0;
}

##==================================================
# ●IDを登録
## set( name, cnt );
sub set {
	my $self = shift;
	my $name = shift;			# 名前
	my $cnt = shift;			# カウント値

	$self->{'Count'}->{ $name } = $cnt;
}

##==================================================
# ●IDを削除
## unset( name );
sub unset {
	my $self = shift;
	my $name = shift;			# 名前

	delete( $self->{'Count'}->{ $name } );
}

##==================================================
# ●カウント値を返す
## count( name );
sub count {
	my $self = shift;
	my $name = shift;			# 名前

	$self->_resetcount( $name );
	return $self->{'Count'}->{ $name };
}

##==================================================
# ●カウンタが未定義ならカウント値をリセット
## _resetcount( name )
sub _resetcount {
	my $self = shift;
	my $name = shift;

	# カウンタがあれば終了
	return 0 if ( exists( $self->{'Count'}->{ $name } ) );

	# カウンタがなければ規定値でリセット
	$self->set( $name, $self->{'DefaultCount'} );
	return 1;
}

##==================================================
##sub lap {
##	my $self = shift;
##	my $msg = shift;
##		$msg = '' unless defined($msg);
##	$self->{'tm2'} = [ gettimeofday ];
##	my $tvi = tv_interval( $self->{'tm1'}, $self->{'tm2'} );
##	printf( "\n == [%.6f] %s\n", $tvi, $msg );
##	$self->{'tm1'} = $self->{'tm2'};
##	return;
##}

printf("\n(%s) [ %s ] ", $VERSION->[-1], __PACKAGE__ );

#===========================================================
=pod
=encoding utf8
=head1 スクリプト名
Debug.pm - デバッグライブラリ
=head1 著者
naoit0 <https://www.naoit0.com/>
=cut
1;