BEGIN {
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

#---------------------
package App;

use utf8;
use strict;
use warnings;
use Data::Dumper;
use Encode;

use BBS;
use base qw( BBS );
my $app = new App();
$app->start(8888);


sub logon {
	my $self = shift;

	# イベント発動元のノード番号を返す
	my $from = $self->from();

	# カウンタをセット
	$self->node( $from )->{'Count'} = 100;
}

sub logoff {
	my $self = shift;

	# イベント発動元のノード番号を返す
	my $from = $self->from();

	# カウンタをセット
	$self->send( $from, "\r\n\r\nbye" );
}

sub output {
	my $self = shift;

	# イベント発動元のノード番号を得る
	my $from = $self->from();

	# カウンタ値を取得
	my $cnt = $self->node( $from )->{'Count'};

	# 値がセットされていたら送出
	$self->send( $from, "\r\n$cnt" ) if ( defined( $cnt ) );
}

sub appwork {
	my $self = shift;

	# イベント発動元のノード番号を得る
	my $from = $self->from();
	
	# カウンタ値を取得
	my $cnt = $self->node( $from )->{'Count'};

	# 値がセットされていなければ終了
	return unless( defined( $cnt ) );

	# 値が0以上なら
	if ( $cnt >= 0 ) {
		# カウントダウン
		$cnt--;

		# 更新したカウンタ値をセット
		$self->node( $from )->{'Count'} = $cnt;
	}
	# 値が0以下なら
	if ( $cnt < 0 ) {
		# 切断
		$self->disconnect( $from );
	}
}

1;