BEGIN {
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

#---------------------
package App;

use utf8;
use strict;
use warnings;
use Data::Dumper;
use Encode;

use BBS;
use base qw( BBS );
my $app = new App();

# logonハンドラ
sub logon {
	my $self = shift;
	my $me = $self->from();

	printf "\n( %d ) 接続しました", $me;
	printf "\n接続ノード : [ %s ]\n", join( ',', $self->nodelist() );

	# 送信バッファを確保
	$self->node( $me )->{'SendBuffer'} = [ ];

	$self->send( $me, "\r\n($me) : Welcome!\r\n" );
}

# logoffハンドラ
sub logoff {
	my $self = shift;
	printf "\n( %d ) 切断しました", $self->from();
	printf "\n接続ノード : [ %s ]\n", join( ',', $self->nodelist() );
}

# inputハンドラ
sub input {
	my $self = shift;
	my $to = $self->from();			# 送信先ノード番号（＝送信元ノード番号）を取得
	my $data = $self->recv();		# 受信データを取得

	# ブロードキャスト
	my @tonodes = $self->nodelist();
	map { $self->send( $_, $data ) } @tonodes;		# 受信データを全ノードに送信
	print "\n".Dumper( $self );		# ????
}

# (2) 送信データをバッファリングするよう送信関数をオーバーライドします。
## send( node, data )
sub send {
	printf "\n\n{ %s } ( %s )", __PACKAGE__.'::send', Debug::_caller(caller);			# ????
	my $self = shift;
	my $node = shift;
	my $data = shift;

	push( @{ $self->node( $node )->{'SendBuffer'} }, $data );
}

# (2) 送信データをバッファリングするよう送信関数をオーバーライドします。
sub output {
	my $self = shift;
	my $me = $self->from();

	# 送信バッファから送信データを取り出す
	my $data = shift( @{ $self->node( $me )->{'SendBuffer'} } );
	return unless defined( $data );

	# 親クラスの送信関数を呼び出す(送信関数をオーバーライドしているため)
	$self->SUPER::send( $me, $data );
}

$app->start(8888);
