BEGIN {
	binmode STDIN, ':encoding(cp932)';
	binmode STDOUT, ':encoding(cp932)';
	binmode STDERR, ':encoding(cp932)';

	use Data::Dumper;
	use FindBin;
	my $basedir = $FindBin::Bin;
	my $baselib = "$FindBin::Bin/../../lib";
	printf "\n** execpath = [ %s ]\n", $basedir;

	our $includelibs = [
		$baselib,
	];
	map { unshift( @INC, $_ ) } @{ $includelibs };
	# print "\n".Dumper( @INC )."\n";
	# インクルードバスを変更したら settings.json の perlnavigator.includePaths も変更する
};

#---------------------
package App;

use utf8;
use strict;
use warnings;
use Data::Dumper;
use Encode;

use BBS;
use base qw( BBS );
my $app = new App();

# logonハンドラ
sub logon {
	my $self = shift;
	printf "\n( %d ) 接続しました", $self->from();
	printf "\n接続ノード : [ %s ]\n", join( ',', $self->nodelist() );

	$self->from_node()->{'SendBuffer'} = [ ];
}

# logoffハンドラ
sub logoff {
	my $self = shift;
	printf "\n( %d ) 切断しました", $self->from();
	printf "\n接続ノード : [ %s ]\n", join( ',', $self->nodelist() );
}

# inputハンドラ
sub input {
	my $self = shift;
	my $to = $self->from();		# 送信先ノード番号（＝送信元ノード番号）を取得
	my $data = $self->recv();	# 受信データを取得

	# 送信データをバッファに保存
	push( @{ $self->node( $to )->{'SendBuffer'} }, $data );
	print "\n".Dumper( $self->node( $to ) );
}

# outputハンドラ
sub output {
	my $self = shift;
	my $to = $self->from();		# 送信先ノード番号（＝送信元ノード番号）を取得

	my $data = shift( @{ $self->node( $to )->{'SendBuffer'} } );	# 送信データを取得
	$self->send( $to, $data );										# 受信データを送信
}

$app->start(8888);
